/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.leospa.clients;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

import com.leospa.properties.ConfigPropertiesFile;

/**
 *
 * @author ADMIN
 */

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;

public class SerialClient {


	public static String TalkRFID(String portName, String hexStringTx, int Timeout) {
		String str = "";
		try {
			CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(portName);
			SerialPort serialPort = (SerialPort) portId.open("Demo application", 5000);
			serialPort.setSerialPortParams(9600, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
			OutputStream outputStream = serialPort.getOutputStream();
			InputStream inputStream = serialPort.getInputStream();
			byte[] tx = hexStringToCharArray(hexStringTx);
			outputStream.write(tx);

			boolean dataValid = false;

			int msCount = 0;
			byte[] bufferRead = new byte[100];
			int byteindex = 0;
			while (Timeout-- > 0) {
				if (inputStream.available() > 0) {
					byte b = (byte) inputStream.read();
					bufferRead[byteindex] = b;
					byteindex++;
					msCount = 0;
				}
				msCount++;
				Thread.sleep(1);
				if (msCount > 50) {
					msCount = 0;
					dataValid = true;
				}

				if (dataValid) {
					if (byteindex > 0) {
						String hexString = "";
						for (int i = 0; i < byteindex; i++) {
							String hex = Integer.toHexString(bufferRead[i]);

							if (hex.length() < 2) {
								hex = "0" + hex;
							} else if (hex.length() > 2) {
								hex = hex.substring(hex.length() - 2);
							}
							if (i < (byteindex - 1)) {
								hex += " ";
							}
							hexString += hex;
						}
						str = hexString;
						break;
					}
					byteindex = 0;
					msCount = 0;
					dataValid = false;
				}
			}

			inputStream.close();
			outputStream.close();
			serialPort.close();
			return str;
		} catch (NoSuchPortException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("No such port as specified in Config.txt, portName: " + portName);
			// if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
			}} catch (PortInUseException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Port " + portName + " is \"In Use\"");}
			// if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		} catch (UnsupportedCommOperationException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		}

		return "";
	}

	public static String TalkRelay(String portName, String hexStringTx, int Timeout) {
		System.out.println("PortName: "+portName+", HexStringTx: "+hexStringTx+", Timeout: "+Timeout);
		String str = "";
		try {
			CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(portName);
			SerialPort serialPort = (SerialPort) portId.open("Demo application", 5000);
			serialPort.setSerialPortParams(38400, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
			OutputStream outputStream = serialPort.getOutputStream();
			InputStream inputStream = serialPort.getInputStream();
			byte[] tx = hexStringToCharArray(hexStringTx);
			outputStream.write(tx);

			boolean dataValid = false;

			int msCount = 0;
			byte[] bufferRead = new byte[100];
			int byteindex = 0;
			while (Timeout-- > 0) {
				if (inputStream.available() > 0) {
					byte b = (byte) inputStream.read();
					bufferRead[byteindex] = b;
					byteindex++;
					msCount = 0;
				}
				msCount++;
				Thread.sleep(1);
				if (msCount > 50) {
					msCount = 0;
					dataValid = true;
				}

				if (dataValid) {
					if (byteindex > 0) {
						String hexString = "";
						for (int i = 0; i < byteindex; i++) {
							String hex = Integer.toHexString(bufferRead[i]);

							if (hex.length() < 2) {
								hex = "0" + hex;
							} else if (hex.length() > 2) {
								hex = hex.substring(hex.length() - 2);
							}
							if (i < (byteindex - 1)) {
								hex += " ";
							}
							hexString += hex;
						}
						str = hexString;
						break;
					}
					byteindex = 0;
					msCount = 0;
					dataValid = false;
				}
			}

			inputStream.close();
			outputStream.close();
			serialPort.close();
			System.out.println("=============================Status: "+str);
			return str;
		} catch (NoSuchPortException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("No such port as specified in Config.txt, portName: " + portName);
			// if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		}} catch (PortInUseException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Port " + portName + " is \"In Use\"");
			// if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		}} catch (IOException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		} catch (UnsupportedCommOperationException e) {
			// TODO Auto-generated catch block
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		}

		return "";
	}

	private static int hexToInt(char ch) {
		if ('a' <= ch && ch <= 'f') {
			return ch - 'a' + 10;
		}
		if ('A' <= ch && ch <= 'F') {
			return ch - 'A' + 10;
		}
		if ('0' <= ch && ch <= '9') {
			return ch - '0';
		}
		throw new IllegalArgumentException(String.valueOf(ch));
	}

	static String hexToAscii(String s) {
		int n = s.length();
		StringBuilder sb = new StringBuilder(n / 2);
		for (int i = 0; i < n; i += 2) {
			char a = s.charAt(i);
			char b = s.charAt(i + 1);
			sb.append((char) ((hexToInt(a) << 4) | hexToInt(b)));
		}
		return sb.toString();
	}

	static byte[] hexStringToCharArray(String s) {
		String[] strr = s.split(" ");
		byte[] r = new byte[strr.length];
		for (int j = 0; j < strr.length; j++) {
			char a = strr[j].charAt(0);
			char b = strr[j].charAt(1);
			r[j] = (byte) ((hexToInt(a) << 4) | hexToInt(b));
		}
		return r;
	}

	public static String getHFCardSerialNumber() {
		String cardSerialNumber = "";
		String headerPacket = "aa 00 00";
		String rx = TalkRFID("/dev/"+ConfigPropertiesFile.HFComPort,  ConfigPropertiesFile.HFSerielNumCmd, 1000);
		if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println(rx);}

		//aa 00 09 00 00 04 88 7a 42 ea 4c 80 9b bb
		String[] rfPacket = rx.split("  ?");
		if (rfPacket[2].equals("02") && rfPacket[3].equals("01")) {
			return null;
		}

		int len = Integer.parseInt(rfPacket[2]);

		int dataLength = rfPacket.length - 2;

		for (int i = 4; i < dataLength; i++) {
			cardSerialNumber = cardSerialNumber+rfPacket[i];
		}
		if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("cardSerialNumber=============="+cardSerialNumber);}
		return cardSerialNumber;
	}

	public static String getLFCardSerialNumber() {
		String cardSerialNumber = "";
		String headerPacket = "aa";
		String rx = TalkRFID("/dev/"+ConfigPropertiesFile.LFComPort, ConfigPropertiesFile.LFSerielNumCmd, 1000);
		String[] rfPacket = rx.split("  ?");
		if (rfPacket[2].equals("01") && rfPacket[3].equals("01")) {
			return null;
		}

		int len = Integer.parseInt(rfPacket[2]);

		int dataLength = rfPacket.length - 2;

		for (int i = 4; i < dataLength; i++) {
			cardSerialNumber = cardSerialNumber+rfPacket[i];
		}

		return cardSerialNumber;
	}

	public static String turnRelaySwitch1_On() {
		String status = null;
		if(ConfigPropertiesFile.OS_TYPE.equals("Window")){
			status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch1_on, 1000);
			//Retry 6 time to one relay
			for(int retryCounter=1;retryCounter<7;retryCounter++) {
				String relayStatus = relayStatus(ConfigPropertiesFile.Relay1_status_window);
				boolean switchStatus = relaySwitchStatus(relayStatus,1);
				if(switchStatus) {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Relay Switch1 On, Retry Counter: "+retryCounter);}
					break;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Relay Switch1 Retry Counter: "+retryCounter);}
					status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch1_on, 1000);
				}
			}
		} else {
			relayOnLinux(ConfigPropertiesFile.RelaySwitch1_on_linux);
			//Retry 6 time to one relay
			for(int retryCounter=1;retryCounter<7;retryCounter++) {
				String relayStatus = relayStatus(ConfigPropertiesFile.Relay1_status_linux);
				boolean switchStatus = relaySwitchStatus(relayStatus,1);
				if(switchStatus) {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Relay Switch1 On, Retry Counter: "+retryCounter);}
					break;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Relay Switch1 Retry Counter: "+retryCounter);}
					relayOnLinux(ConfigPropertiesFile.RelaySwitch1_on_linux);
				}
			}
		}
		return status;

	}
	
	public static void main(String[] args) {
		SerialClient.relayOnLinux(ConfigPropertiesFile.RelaySwitch1_on_linux);
	}
	
	public static boolean relaySwitchStatus(String returnData, Integer switchNumber) {
		if(ConfigPropertiesFile.DEMO_MODE==true) {
			returnData = "02 3C 29 33 31 30 03 27"; //demo returnData from relay
		}
		String statusSplit[] = returnData.split(" ");
		if(statusSplit.length==8) {
			String switch1 = statusSplit[4];
			String switch2 = statusSplit[5];
			if(switchNumber==1) {
				if(switch1.equalsIgnoreCase("30")) {
					return false;
				}else if(switch1.equalsIgnoreCase("31")) {
					return true;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Switch1 Status Not Specified....");}
					return false;
				}
			}else if(switchNumber==2) {
				if(switch2.equalsIgnoreCase("30")) {
					return false;
				}else if(switch2.equalsIgnoreCase("31")) {
					return true;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Switch2 Status Not Specified....");}
					return false;
				}
			}else {
				if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Switch Not Determine...............");}
				return false;
			}
			
		}else {
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Wrong returnData Format: "+returnData);}
			return false;
		}
	}
	public static String relayStatus(String commandDevice){
		if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("=============================================================Relay Status Method Called...."+commandDevice);}
		try {
			StringBuffer sb = new StringBuffer();
			Process p = Runtime.getRuntime().exec("stty -F /dev/"+ConfigPropertiesFile.RelayComPort+" 38400");
			p.waitFor();
			BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line = "";
			while ((line = reader.readLine())!= null) {
			    		sb.append(line + "\n");
			}
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("First Command Execute: "+sb.toString());}
			
			
//			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Command "+"stty -F /dev/"+ConfigPropertiesFile.RelayComPort);}
			p = Runtime.getRuntime().exec("stty -F /dev/"+ConfigPropertiesFile.RelayComPort);
			p.waitFor();
			sb = new StringBuffer();
			reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
			line = "";
			while ((line = reader.readLine())!= null) {
				sb.append(line + "\n");
			}
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println(sb.toString());}
			
			commandDevice = commandDevice.replace("x", "\\x");
			System.out.println(commandDevice);
			String[] cmdline = { "bash", "-c", "echo -e \""+commandDevice+"\" > /dev/"+ConfigPropertiesFile.RelayComPort }; 	
			System.out.print(cmdline);
			p = Runtime.getRuntime().exec(cmdline);
		    p.waitFor();
			sb = new StringBuffer();
			reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
			line = "";
			while ((line = reader.readLine())!= null) {
				sb.append(line + "\n");
			}
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Relay Device Status -> Command: "+commandDevice+", Return value: "+sb.toString());}
			return sb.toString();
		}catch (Exception e) {
			
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true)
			{e.printStackTrace();}
			return "error";
		}
	}
	
	public static void relayOnLinux(String relaySwitch){
		System.out.println("===============================Relay on Command executed.......");
		try {
			StringBuffer sb = new StringBuffer();
			Process p = Runtime.getRuntime().exec("stty -F /dev/"+ConfigPropertiesFile.RelayComPort+" 38400");
			p.waitFor();
			BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line = "";
			while ((line = reader.readLine())!= null) {
			    		sb.append(line + "\n");
			}
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Return data: "+sb.toString());}
			
			
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Command "+"stty -F /dev/"+ConfigPropertiesFile.RelayComPort);}
			p = Runtime.getRuntime().exec("stty -F /dev/"+ConfigPropertiesFile.RelayComPort);
			p.waitFor();
			sb = new StringBuffer();
			reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
			line = "";
			while ((line = reader.readLine())!= null) {
				sb.append(line + "\n");
			}
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Return data: "+sb.toString());}
			
			relaySwitch = relaySwitch.replace("x", "\\x");
			System.out.print(relaySwitch);
			String[] cmdline = { "bash", "-c", "echo -e \""+relaySwitch+"\" > /dev/"+ConfigPropertiesFile.RelayComPort }; 	
			System.out.print(cmdline);
			p = Runtime.getRuntime().exec(cmdline);
		    p.waitFor();
			sb = new StringBuffer();
			reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
			line = "";
			while ((line = reader.readLine())!= null) {
				sb.append(line + "\n");
			}
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Return Data: "+sb.toString());}
			System.out.println("===============================Relay on Command execution Finish.......");
		}catch (Exception e) {
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true)
			{e.printStackTrace();}
		}
	}
	

	public static void relayOffLinux(String relaySwitch){
		try {
			Process p = Runtime.getRuntime().exec("stty -F /dev/"+ConfigPropertiesFile.RelayComPort+" 38400");
			p.waitFor();
			relaySwitch = relaySwitch.replace("x", "\\x");
			String[] cmdline = { "bash", "-c", "echo -e \""+relaySwitch+"\" > /dev/"+ConfigPropertiesFile.RelayComPort }; 		    
			p = Runtime.getRuntime().exec(cmdline);
		    p.waitFor();
		}catch (Exception e) {
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true) 
			{e.printStackTrace();}
		}
	}

	public static String turnRelaySwitch2_On() {
		String status = null;
		if(ConfigPropertiesFile.OS_TYPE.equals("Window")){
			status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch2_on, 1000);
			//Retry 6 time to one relay
			for(int retryCounter=1;retryCounter<7;retryCounter++) {
				String relayStatus = relayStatus(ConfigPropertiesFile.Relay1_status_window);
				boolean switchStatus = relaySwitchStatus(relayStatus,2);
				if(switchStatus) {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Relay Switch2 On, Retry Counter: "+retryCounter);}
					break;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Relay Switch2 Retry Counter: "+retryCounter);}
					status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch2_on, 1000);
				}
			}
		}else {
			relayOnLinux(ConfigPropertiesFile.RelaySwitch2_on_linux);
			//Retry 6 time to one relay
			for(int retryCounter=1;retryCounter<7;retryCounter++) {
				String relayStatus = relayStatus(ConfigPropertiesFile.Relay1_status_linux);
				boolean switchStatus = relaySwitchStatus(relayStatus,2);
				if(switchStatus) {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Relay Switch2 On, Retry Counter: "+retryCounter);}
					break;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Relay Switch2 Retry Counter: "+retryCounter);}
					relayOnLinux(ConfigPropertiesFile.RelaySwitch2_on_linux);
				}
			}
		}
		return status;

	}
	
	public static String turnRelaySwitch3_On() {
		String status = null;
		if(ConfigPropertiesFile.OS_TYPE.equals("Window")){
			status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch3_on, 1000);
		}else {
			relayOnLinux(ConfigPropertiesFile.RelaySwitch3_on_linux);
		}
		return status;

	}
	
	public static String turnRelaySwitch4_On() {
		String status = null;
		if(ConfigPropertiesFile.OS_TYPE.equals("Window")){
			status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch4_on, 1000);
		}else {
			relayOnLinux(ConfigPropertiesFile.RelaySwitch4_on_linux);
		}
		return status;

	}

	public static String turnRelaySwitch1_Off() {
		String status = null;
		if(ConfigPropertiesFile.OS_TYPE.equals("Window")){
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Work Well");}
			status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch1_off, 1000);
			for(int retryCounter=1;retryCounter<7;retryCounter++) {
				String relayStatus = relayStatus(ConfigPropertiesFile.Relay1_status_window);
				boolean switchStatus = relaySwitchStatus(relayStatus,1);
				if(!switchStatus) {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Relay Switch1 off, Retry Counter: "+retryCounter);}
					break;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Relay Switch1 Retry Counter: "+retryCounter);}
					status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch1_off, 1000);
				}
			}
		} else {
			relayOffLinux(ConfigPropertiesFile.RelaySwitch1_off_linux);
			for(int retryCounter=1;retryCounter<7;retryCounter++) {
				String relayStatus = relayStatus(ConfigPropertiesFile.Relay1_status_linux);
				boolean switchStatus = relaySwitchStatus(relayStatus,1);
				if(!switchStatus) {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Relay Switch1 off, Retry Counter: "+retryCounter);}
					break;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Relay Switch1 Retry Counter: "+retryCounter);}
					relayOffLinux(ConfigPropertiesFile.RelaySwitch1_off_linux);
				}
			}
		}
		return status;

	}

	public static String turnRelaySwitch2_Off() {
		String status = null;
		if(ConfigPropertiesFile.OS_TYPE.equals("Window")){
			status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch2_off, 1000);
			for(int retryCounter=1;retryCounter<7;retryCounter++) {
				String relayStatus = relayStatus(ConfigPropertiesFile.Relay1_status_window);
				boolean switchStatus = relaySwitchStatus(relayStatus,2);
				if(!switchStatus) {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Relay Switch2 off, Retry Counter: "+retryCounter);}
					break;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Relay Switch2 Retry Counter: "+retryCounter);}
					status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch2_off, 1000);
				}
			}
		}else {
			relayOffLinux(ConfigPropertiesFile.RelaySwitch2_off_linux);
			for(int retryCounter=1;retryCounter<7;retryCounter++) {
				String relayStatus = relayStatus(ConfigPropertiesFile.Relay1_status_linux);
				boolean switchStatus = relaySwitchStatus(relayStatus,2);
				if(!switchStatus) {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.out.println("Relay Switch2 off, Retry Counter: "+retryCounter);}
					break;
				}else {
					if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("Relay Switch2 Retry Counter: "+retryCounter);}
					relayOffLinux(ConfigPropertiesFile.RelaySwitch2_off_linux);
				}
			}
		}
		return status;

	}
	
	public static String turnRelaySwitch3_Off() {
		String status = null;
		if(ConfigPropertiesFile.OS_TYPE.equals("Window")){
			status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch3_off, 1000);
		} else {
			relayOffLinux(ConfigPropertiesFile.RelaySwitch3_off_linux);
		}
		return status;

	}
	
	public static String turnRelaySwitch4_Off() {
		String status = null;
		if(ConfigPropertiesFile.OS_TYPE.equals("Window")){
			status = TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch4_off, 1000);
		} else {
			relayOffLinux(ConfigPropertiesFile.RelaySwitch4_off_linux);
		}
		return status;

	}

	public static String getCardSerialNumber() {
		if(ConfigPropertiesFile.DEBUG_MODE_ON == true){System.err.println("m here 1111111111");}
		/*
		 * Following code gets the serial number by using LF reader
		 */
		String cardSerialNumber = null;
		try {
			if(ConfigPropertiesFile.CARD_TYPE.equals("LF")){
				cardSerialNumber = getLFCardSerialNumber();
			} else {
				cardSerialNumber = getHFCardSerialNumber();
			}
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){ System.out.println("Card Seriel Number" + cardSerialNumber);}
			if (cardSerialNumber != null) {
			}
		} catch (Exception e) {
			if(ConfigPropertiesFile.DEBUG_MODE_ON == true){e.printStackTrace();}
		} finally {
			return cardSerialNumber;
		}
	}

}
